/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.MessageCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimingsReportListener
implements MessageCommandSender {
    private final List<CommandSender> senders;
    private final Runnable onDone;
    private String timingsURL;

    public TimingsReportListener(@NotNull CommandSender senders) {
        this(senders, null);
    }

    public TimingsReportListener(@NotNull CommandSender sender, @Nullable Runnable onDone) {
        this(Lists.newArrayList((Object[])new CommandSender[]{sender}), onDone);
    }

    public TimingsReportListener(@NotNull List<CommandSender> senders) {
        this(senders, null);
    }

    public TimingsReportListener(@NotNull List<CommandSender> senders, @Nullable Runnable onDone) {
        Validate.notNull(senders);
        Validate.notEmpty(senders);
        this.senders = Lists.newArrayList(senders);
        this.onDone = onDone;
    }

    @Nullable
    public String getTimingsURL() {
        return this.timingsURL;
    }

    public void done() {
        this.done(null);
    }

    public void done(@Nullable String url) {
        this.timingsURL = url;
        if (this.onDone != null) {
            this.onDone.run();
        }
        for (CommandSender sender : this.senders) {
            if (!(sender instanceof TimingsReportListener)) continue;
            ((TimingsReportListener)sender).done();
        }
    }

    @Override
    public void sendMessage(@NotNull String message) {
        this.senders.forEach(sender -> sender.sendMessage(message));
    }

    public void addConsoleIfNeeded() {
        boolean hasConsole = false;
        for (CommandSender sender : this.senders) {
            if (!(sender instanceof ConsoleCommandSender) && !(sender instanceof RemoteConsoleCommandSender)) continue;
            hasConsole = true;
        }
        if (!hasConsole) {
            this.senders.add(Bukkit.getConsoleSender());
        }
    }
}

