/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import com.google.common.base.Objects;
import java.util.StringJoiner;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class GoalKey<T extends Mob> {
    private final Class<T> entityClass;
    private final NamespacedKey namespacedKey;

    private GoalKey(@NotNull Class<T> entityClass, @NotNull NamespacedKey namespacedKey) {
        this.entityClass = entityClass;
        this.namespacedKey = namespacedKey;
    }

    @NotNull
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @NotNull
    public NamespacedKey getNamespacedKey() {
        return this.namespacedKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoalKey goalKey = (GoalKey)o;
        return Objects.equal(this.entityClass, goalKey.entityClass) && Objects.equal((Object)this.namespacedKey, (Object)goalKey.namespacedKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entityClass, this.namespacedKey});
    }

    public String toString() {
        return new StringJoiner(", ", GoalKey.class.getSimpleName() + "[", "]").add("entityClass=" + this.entityClass).add("namespacedKey=" + this.namespacedKey).toString();
    }

    @NotNull
    public static <A extends Mob> GoalKey<A> of(@NotNull Class<A> entityClass, @NotNull NamespacedKey namespacedKey) {
        return new GoalKey<A>(entityClass, namespacedKey);
    }
}

