/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleBuilder {
    private Particle particle;
    private List<Player> receivers;
    private Player source;
    private Location location;
    private int count = 1;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetZ = 0.0;
    private double extra = 1.0;
    private Object data;
    private boolean force = true;

    public ParticleBuilder(@NotNull Particle particle) {
        this.particle = particle;
    }

    @NotNull
    public ParticleBuilder spawn() {
        if (this.location == null) {
            throw new IllegalStateException("Please specify location for this particle");
        }
        this.location.getWorld().spawnParticle(this.particle, this.receivers, this.source, this.location.getX(), this.location.getY(), this.location.getZ(), this.count, this.offsetX, this.offsetY, this.offsetZ, this.extra, this.data, this.force);
        return this;
    }

    @NotNull
    public Particle particle() {
        return this.particle;
    }

    @NotNull
    public ParticleBuilder particle(@NotNull Particle particle) {
        this.particle = particle;
        return this;
    }

    @Nullable
    public List<Player> receivers() {
        return this.receivers;
    }

    public boolean hasReceivers() {
        return this.receivers == null && !this.location.getWorld().getPlayers().isEmpty() || this.receivers != null && !this.receivers.isEmpty();
    }

    @NotNull
    public ParticleBuilder allPlayers() {
        this.receivers = null;
        return this;
    }

    @NotNull
    public ParticleBuilder receivers(@Nullable List<Player> receivers) {
        this.receivers = receivers != null ? Lists.newArrayList(receivers) : null;
        return this;
    }

    @NotNull
    public ParticleBuilder receivers(@Nullable Collection<Player> receivers) {
        this.receivers = receivers != null ? Lists.newArrayList(receivers) : null;
        return this;
    }

    @NotNull
    public ParticleBuilder receivers(Player ... receivers) {
        this.receivers = receivers != null ? Lists.newArrayList((Object[])receivers) : null;
        return this;
    }

    @NotNull
    public ParticleBuilder receivers(int radius) {
        return this.receivers(radius, radius);
    }

    @NotNull
    public ParticleBuilder receivers(int radius, boolean byDistance) {
        if (!byDistance) {
            return this.receivers(radius, radius, radius);
        }
        this.receivers = Lists.newArrayList();
        for (Player nearbyPlayer : this.location.getWorld().getNearbyPlayers(this.location, (double)radius, (double)radius, radius)) {
            double z;
            double y;
            Location loc = nearbyPlayer.getLocation();
            double x = NumberConversions.square(this.location.getX() - loc.getX());
            if (Math.sqrt(x + (y = NumberConversions.square(this.location.getY() - loc.getY())) + (z = NumberConversions.square(this.location.getZ() - loc.getZ()))) > (double)radius) continue;
            this.receivers.add(nearbyPlayer);
        }
        return this;
    }

    @NotNull
    public ParticleBuilder receivers(int xzRadius, int yRadius) {
        return this.receivers(xzRadius, yRadius, xzRadius);
    }

    @NotNull
    public ParticleBuilder receivers(int xzRadius, int yRadius, boolean byDistance) {
        if (!byDistance) {
            return this.receivers(xzRadius, yRadius, xzRadius);
        }
        this.receivers = Lists.newArrayList();
        for (Player nearbyPlayer : this.location.getWorld().getNearbyPlayers(this.location, (double)xzRadius, (double)yRadius, xzRadius)) {
            double z;
            double x;
            Location loc = nearbyPlayer.getLocation();
            if (Math.abs(loc.getY() - this.location.getY()) > (double)yRadius || (x = NumberConversions.square(this.location.getX() - loc.getX())) + (z = NumberConversions.square(this.location.getZ() - loc.getZ())) > NumberConversions.square(xzRadius)) continue;
            this.receivers.add(nearbyPlayer);
        }
        return this;
    }

    @NotNull
    public ParticleBuilder receivers(int xRadius, int yRadius, int zRadius) {
        if (this.location == null) {
            throw new IllegalStateException("Please set location first");
        }
        return this.receivers(this.location.getWorld().getNearbyPlayers(this.location, (double)xRadius, (double)yRadius, zRadius));
    }

    @Nullable
    public Player source() {
        return this.source;
    }

    @NotNull
    public ParticleBuilder source(@Nullable Player source) {
        this.source = source;
        return this;
    }

    @Nullable
    public Location location() {
        return this.location;
    }

    @NotNull
    public ParticleBuilder location(@NotNull Location location) {
        this.location = location.clone();
        return this;
    }

    @NotNull
    public ParticleBuilder location(@NotNull World world, double x, double y, double z) {
        this.location = new Location(world, x, y, z);
        return this;
    }

    public int count() {
        return this.count;
    }

    @NotNull
    public ParticleBuilder count(int count) {
        this.count = count;
        return this;
    }

    public double offsetX() {
        return this.offsetX;
    }

    public double offsetY() {
        return this.offsetY;
    }

    public double offsetZ() {
        return this.offsetZ;
    }

    @NotNull
    public ParticleBuilder offset(double offsetX, double offsetY, double offsetZ) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        return this;
    }

    public double extra() {
        return this.extra;
    }

    @NotNull
    public ParticleBuilder extra(double extra) {
        this.extra = extra;
        return this;
    }

    @Nullable
    public <T> T data() {
        return (T)this.data;
    }

    @NotNull
    public <T> ParticleBuilder data(@Nullable T data) {
        this.data = data;
        return this;
    }

    @NotNull
    public ParticleBuilder force(boolean force) {
        this.force = force;
        return this;
    }

    @NotNull
    public ParticleBuilder color(@Nullable Color color) {
        return this.color(color, 1.0f);
    }

    @NotNull
    public ParticleBuilder color(@Nullable Color color, float size) {
        if (this.particle != Particle.REDSTONE && color != null) {
            throw new IllegalStateException("Color may only be set on REDSTONE");
        }
        if (color == null) {
            if (this.data instanceof Particle.DustOptions) {
                return this.data(null);
            }
            return this;
        }
        return this.data(new Particle.DustOptions(color, size));
    }

    @NotNull
    public ParticleBuilder color(int r, int g, int b) {
        return this.color(Color.fromRGB(r, g, b));
    }
}

