/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncTabCompleteEvent
extends Event
implements Cancellable {
    @NotNull
    private final CommandSender sender;
    @NotNull
    private final String buffer;
    private final boolean isCommand;
    @Nullable
    private final Location loc;
    @NotNull
    private List<String> completions;
    private boolean cancelled;
    private boolean handled = false;
    private boolean fireSyncHandler = true;
    private static final HandlerList handlers = new HandlerList();

    public AsyncTabCompleteEvent(@NotNull CommandSender sender, @NotNull List<String> completions, @NotNull String buffer, boolean isCommand, @Nullable Location loc) {
        super(true);
        this.sender = sender;
        this.completions = completions;
        this.buffer = buffer;
        this.isCommand = isCommand;
        this.loc = loc;
    }

    @NotNull
    public CommandSender getSender() {
        return this.sender;
    }

    @NotNull
    public List<String> getCompletions() {
        return this.completions;
    }

    public void setCompletions(@NotNull List<String> completions) {
        Validate.notNull(completions);
        this.completions = new ArrayList<String>(completions);
    }

    @NotNull
    public String getBuffer() {
        return this.buffer;
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    @Nullable
    public Location getLocation() {
        return this.loc;
    }

    public boolean isHandled() {
        return !this.completions.isEmpty() || this.handled;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

