/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.UseBlockEvent;
import com.sk89q.worldguard.bukkit.event.entity.DamageEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.DestroyEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.SpawnEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.UseEntityEvent;
import com.sk89q.worldguard.bukkit.event.inventory.UseItemEvent;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class BuildPermissionListener
extends AbstractListener {
    public BuildPermissionListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    private boolean hasBuildPermission(CommandSender sender, String perm) {
        return this.getPlugin().hasPermission(sender, "worldguard.build." + perm);
    }

    private void tellErrorMessage(CommandSender sender, org.bukkit.World world) {
        String message = BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)world)).buildPermissionDenyMessage;
        if (!message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlaceBlock(PlaceBlockEvent event) {
        if (!BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).buildPermissions) {
            return;
        }
        Object rootCause = event.getCause().getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            Material material = event.getEffectiveMaterial();
            if (!this.hasBuildPermission((CommandSender)player, "block." + material.name().toLowerCase() + ".place") && !this.hasBuildPermission((CommandSender)player, "block.place." + material.name().toLowerCase())) {
                this.tellErrorMessage((CommandSender)player, event.getWorld());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreakBlock(BreakBlockEvent event) {
        if (!BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).buildPermissions) {
            return;
        }
        Object rootCause = event.getCause().getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            Material material = event.getEffectiveMaterial();
            if (!this.hasBuildPermission((CommandSender)player, "block." + material.name().toLowerCase() + ".remove") && !this.hasBuildPermission((CommandSender)player, "block.remove." + material.name().toLowerCase())) {
                this.tellErrorMessage((CommandSender)player, event.getWorld());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseBlock(UseBlockEvent event) {
        if (!BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).buildPermissions) {
            return;
        }
        Object rootCause = event.getCause().getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            Material material = event.getEffectiveMaterial();
            if (!this.hasBuildPermission((CommandSender)player, "block." + material.name().toLowerCase() + ".interact") && !this.hasBuildPermission((CommandSender)player, "block.interact." + material.name().toLowerCase())) {
                this.tellErrorMessage((CommandSender)player, event.getWorld());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpawnEntity(SpawnEntityEvent event) {
        if (!BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).buildPermissions) {
            return;
        }
        Object rootCause = event.getCause().getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            EntityType type = event.getEffectiveType();
            if (!this.hasBuildPermission((CommandSender)player, "entity." + type.name().toLowerCase() + ".place") && !this.hasBuildPermission((CommandSender)player, "entity.place." + type.name().toLowerCase())) {
                this.tellErrorMessage((CommandSender)player, event.getWorld());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDestroyEntity(DestroyEntityEvent event) {
        if (!BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).buildPermissions) {
            return;
        }
        Object rootCause = event.getCause().getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            EntityType type = event.getEntity().getType();
            if (!this.hasBuildPermission((CommandSender)player, "entity." + type.name().toLowerCase() + ".remove") && !this.hasBuildPermission((CommandSender)player, "entity.remove." + type.name().toLowerCase())) {
                this.tellErrorMessage((CommandSender)player, event.getWorld());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseEntity(UseEntityEvent event) {
        if (!BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).buildPermissions) {
            return;
        }
        Object rootCause = event.getCause().getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            EntityType type = event.getEntity().getType();
            if (!this.hasBuildPermission((CommandSender)player, "entity." + type.name().toLowerCase() + ".interact") && !this.hasBuildPermission((CommandSender)player, "entity.interact." + type.name().toLowerCase())) {
                this.tellErrorMessage((CommandSender)player, event.getWorld());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageEntity(DamageEntityEvent event) {
        if (!BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).buildPermissions) {
            return;
        }
        Object rootCause = event.getCause().getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            EntityType type = event.getEntity().getType();
            if (!this.hasBuildPermission((CommandSender)player, "entity." + type.name().toLowerCase() + ".damage") && !this.hasBuildPermission((CommandSender)player, "entity.damage." + type.name().toLowerCase())) {
                this.tellErrorMessage((CommandSender)player, event.getWorld());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseItem(UseItemEvent event) {
        if (!BuildPermissionListener.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).buildPermissions) {
            return;
        }
        Object rootCause = event.getCause().getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            Material material = event.getItemStack().getType();
            if (material.isBlock()) {
                return;
            }
            if (!this.hasBuildPermission((CommandSender)player, "item." + material.name().toLowerCase() + ".use") && !this.hasBuildPermission((CommandSender)player, "item.use." + material.name().toLowerCase())) {
                this.tellErrorMessage((CommandSender)player, event.getWorld());
                event.setCancelled(true);
            }
        }
    }
}

