/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.session;

import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.player.ProcessPlayerEvent;
import com.sk89q.worldguard.bukkit.session.TimedHandlerFactory;
import com.sk89q.worldguard.session.AbstractSessionManager;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class BukkitSessionManager
extends AbstractSessionManager
implements Runnable,
Listener {
    private boolean useTimings;

    protected Handler.Factory<? extends Handler> wrapForRegistration(Handler.Factory<? extends Handler> factory) {
        return this.useTimings ? new TimedHandlerFactory(factory) : factory;
    }

    public void resetAllStates() {
        Collection players = Bukkit.getServer().getOnlinePlayers();
        for (Player player : players) {
            BukkitPlayer bukkitPlayer = new BukkitPlayer(WorldGuardPlugin.inst(), player);
            Session session = this.getIfPresent(bukkitPlayer);
            if (session == null) continue;
            session.resetState((LocalPlayer)bukkitPlayer);
        }
    }

    @EventHandler
    public void onPlayerProcess(ProcessPlayerEvent event) {
        LocalPlayer player = WorldGuardPlugin.inst().wrapPlayer(event.getPlayer());
        this.get(player).initialize(player);
    }

    @Override
    public void run() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            this.get(localPlayer).tick(localPlayer);
        }
    }

    public boolean hasBypass(LocalPlayer player, World world) {
        if (player instanceof BukkitPlayer && ((BukkitPlayer)player).getPlayer().hasMetadata("NPC") && WorldGuard.getInstance().getPlatform().getGlobalStateManager().get((World)world).fakePlayerBuildOverride) {
            return true;
        }
        return super.hasBypass(player, world);
    }

    public boolean isUsingTimings() {
        return this.useTimings;
    }

    public void setUsingTimings(boolean useTimings) {
        this.useTimings = useTimings;
    }
}

